unit UnitTGA;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls;

type
  TTGAForm = class(TForm)
    ButtonExit: TButton;
    GroupBox1: TGroupBox;
    ButtonOpenT: TButton;
    OpenDialog1: TOpenDialog;
    LabelT1: TLabel;
    LabelT2: TLabel;
    GroupBox2: TGroupBox;
    LabelF1: TLabel;
    LabelF2: TLabel;
    ButtonOpenF: TButton;
    Timer1: TTimer;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ButtonStart: TButton;
    LabelDir: TLabel;
    GroupBox3: TGroupBox;
    LabelG1: TLabel;
    LabelG2: TLabel;
    ButtonOpenG: TButton;
    LabelFEMout: TLabel;
    LabelFEMctr: TLabel;
    LabelFEMin: TLabel;
    LabelTriaxFile: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    LabelGAin: TLabel;
    LabelGAout: TLabel;
    LabelGActr: TLabel;
    Label13: TLabel;
    LabelObj: TLabel;
    LabelGA: TLabel;
    LabelFEM: TLabel;
    ButtonBest: TButton;
    GroupBox4: TGroupBox;
    RadioButtonTotal: TRadioButton;
    RadioButtonEffective: TRadioButton;
    ButtonContinue: TButton;
    TrackBar1: TTrackBar;
    Panel1: TPanel;
    TrackBar2: TTrackBar;
    procedure Init(Sender: TObject);
    procedure ButtonExitClick(Sender: TObject);
    procedure ButtonOpenTClick(Sender: TObject);
    procedure ButtonOpenFClick(Sender: TObject);
    procedure ButtonOpenGClick(Sender: TObject);
    procedure WaitFEMDone(Sender: TObject);
    procedure WaitGADone(Sender: TObject);
    procedure ButtonStartClick(Sender: TObject);
    procedure ButtonBestClick(Sender: TObject);
    procedure ButtonContinueClick(Sender: TObject);
    procedure TrackBarOnChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

Experiment = record
             S,z,u,A,e1,s1,s3,s1e,s3e,p,q,pe,s1ds3,s1eds3e,s1ms3 : double;
             end;
Calculation = Record
              dz : double;
              sr,sz,trz,st,u : double;
              e1, s1ms3, s1ds3, s1eds3e, p, q, pe : double
              end;
var
  TGAForm: TTGAForm;
  Data : array[1..5000] of Experiment;
  maxData, maxResults, NVariabs, ITR, ITRmax : word;
  GACounter, FEMCounter, GACounterMax, FEMCounterMax, WaitCounter : word;
  Results : array[1..1000] of Calculation;
  h, r, Objective : double;
  max, scale : array[1..2,1..4] of double;
  FullProbName, ProbName, CurrentDir : string[200];
  FullFEMname, FEMname, FullGAname, GAname, FEMLoadDisp, GAnameAGA : string[200];
  FEMOutName, FEMEndName, FEMCTRname, GACTRname, GAOutName, GADatName : string[200];
  BestName, FEMMonName, BestFitName : string[200];
  FEMActiveData : array[0..20] of double;
  FEMPassiveData : array[1..20] of string[255];
  PHT : array[1..20,1..100] of double;
  FEMok : byte;
  Intval, Sleepval: word;
  DateTime1, DateTime2 : TDateTime;
  constCaption : string;

implementation

uses UnitWarning;

{$R *.dfm}


procedure TTGAForm.Init(Sender: TObject);
begin
  Timer1.Enabled := False;
  //wykres e1:(s1-s3)
  Image1.Canvas.Rectangle(0, 0, Image1.Width, Image1.Height);
  //wykres p:q
  Image2.Canvas.Rectangle(0, 0, Image2.Width, Image2.Height);
  //wykres e1:(s1/s3)
  Image3.Canvas.Rectangle(0, 0, Image3.Width, Image3.Height);
  //wykres e1:u
  Image4.Canvas.Rectangle(0, 0, Image4.Width, Image4.Height);
  Update;
  GACounter := 0;
  IntVal := 200;
  constCaption := 'TGA Project r.090809.0955';
  Caption := constCaption;
  Update;
  SleepVal := 1000;
end;

procedure TTGAForm.ButtonExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure DrawExp;
var i, x, y : integer;
begin
  TGAForm.Image1.Canvas.Pen.Color := clBlack;
  TGAForm.Image2.Canvas.Pen.Color := clBlack;
  TGAForm.Image3.Canvas.Pen.Color := clBlack;
  TGAForm.Image4.Canvas.Pen.Color := clBlack;
  TGAForm.Image1.Canvas.Rectangle(0, 0, TGAForm.Image1.Width, TGAForm.Image1.Height);
  TGAForm.Image2.Canvas.Rectangle(0, 0, TGAForm.Image2.Width, TGAForm.Image2.Height);
  TGAForm.Image3.Canvas.Rectangle(0, 0, TGAForm.Image3.Width, TGAForm.Image3.Height);
  TGAForm.Image4.Canvas.Rectangle(0, 0, TGAForm.Image4.Width, TGAForm.Image4.Height);

  //wykres nr 1
  x := round(scale[1,1]*Data[1].e1);
  y := TGAForm.Image1.Height - round(scale[2,1]*Data[1].s1ms3);
  TGAForm.Image1.Canvas.MoveTo(x,y);
  for i:=2 to maxData do
  begin
    x := round(scale[1,1]*Data[i].e1);
    y := TGAForm.Image1.Height - round(scale[2,1]*Data[i].s1ms3);
    TGAForm.Image1.Canvas.LineTo(x,y);
  end;

  //wykres nr 2
  x := round(scale[1,2]*Data[1].p);
  y := TGAForm.Image2.Height - round(scale[2,2]*Data[1].q);
  TGAForm.Image2.Canvas.MoveTo(x,y);
  for i:=2 to maxData do
  begin
    x := round(scale[1,2]*Data[i].p);
    y := TGAForm.Image2.Height - round(scale[2,2]*Data[i].q);
    TGAForm.Image2.Canvas.LineTo(x,y);
  end;

  //wykres nr 3
  x := round(scale[1,3]*Data[1].e1);
  y := TGAForm.Image3.Height - round(scale[2,3]*Data[1].s1ds3);
  TGAForm.Image3.Canvas.MoveTo(x,y);
  for i:=2 to maxData do
  begin
    x := round(scale[1,3]*Data[i].e1);
    y := TGAForm.Image3.Height - round(scale[2,3]*Data[i].s1ds3);
    TGAForm.Image3.Canvas.LineTo(x,y);
  end;

  //wykres nr 4
  x := round(scale[1,4]*Data[1].e1);
  y := TGAForm.Image4.Height - round(scale[2,4]*Data[1].u);
  TGAForm.Image4.Canvas.MoveTo(x,y);
  for i:=2 to maxData do
  begin
    x := round(scale[1,4]*Data[i].e1);
    y := TGAForm.Image4.Height - round(scale[2,4]*Data[i].u);
    TGAForm.Image4.Canvas.LineTo(x,y);
  end;

  TGAForm.Image2.Canvas.Pen.Color := clBlue;
  TGAForm.Image3.Canvas.Pen.Color := clBlue;
  TGAForm.Image4.Canvas.Pen.Color := clBlue;

  //wykres nr 2
  x := round(scale[1,2]*Data[1].pe);
  y := TGAForm.Image2.Height - round(scale[2,2]*Data[1].q);
  TGAForm.Image2.Canvas.MoveTo(x,y);
  for i:=2 to maxData do
  begin
    x := round(scale[1,2]*Data[i].pe);
    y := TGAForm.Image2.Height - round(scale[2,2]*Data[i].q);
    TGAForm.Image2.Canvas.LineTo(x,y);
  end;

  //wykres nr 3
  x := round(scale[1,3]*Data[1].e1);
  y := TGAForm.Image3.Height - round(scale[2,3]*Data[1].s1eds3e);
  TGAForm.Image3.Canvas.MoveTo(x,y);
  for i:=2 to maxData do
  begin
    x := round(scale[1,3]*Data[i].e1);
    y := TGAForm.Image3.Height - round(scale[2,3]*Data[i].s1eds3e);
    TGAForm.Image3.Canvas.LineTo(x,y);
  end;

  TGAForm.Update;
end;

procedure DrawFEM;
var i, x, y : integer;
begin
  TGAForm.Image1.Canvas.Pen.Color := clRed;
  TGAForm.Image2.Canvas.Pen.Color := clRed;
  TGAForm.Image3.Canvas.Pen.Color := clRed;
  TGAForm.Image4.Canvas.Pen.Color := clRed;

  //wykres nr 1
  x := round(scale[1,1]*Results[1].e1);
  y := TGAForm.Image1.Height - round(scale[2,1]*Results[1].s1ms3);
  TGAForm.Image1.Canvas.MoveTo(x,y);
  for i:=2 to maxResults do
  begin
    x := round(scale[1,1]*Results[i].e1);
    y := TGAForm.Image1.Height - round(scale[2,1]*Results[i].s1ms3);
    TGAForm.Image1.Canvas.LineTo(x,y);
  end;

  //wykres nr 2
  x := round(scale[1,2]*Results[1].p);
  y := TGAForm.Image2.Height - round(scale[2,2]*Results[1].q);
  TGAForm.Image2.Canvas.MoveTo(x,y);
  for i:=2 to maxResults do
  begin
    x := round(scale[1,2]*Results[i].p);
    y := TGAForm.Image2.Height - round(scale[2,2]*Results[i].q);
    TGAForm.Image2.Canvas.LineTo(x,y);
  end;

  //wykres nr 3
  x := round(scale[1,3]*Results[1].e1);
  y := TGAForm.Image3.Height - round(scale[2,3]*Results[1].s1ds3);
  TGAForm.Image3.Canvas.MoveTo(x,y);
  for i:=2 to maxResults do
  begin
    x := round(scale[1,3]*Results[i].e1);
    y := TGAForm.Image3.Height - round(scale[2,3]*Results[i].s1ds3);
    TGAForm.Image3.Canvas.LineTo(x,y);
  end;

  //wykres nr 4
  x := round(scale[1,4]*Results[1].e1);
  y := TGAForm.Image4.Height - round(scale[2,4]*Results[1].u);
  TGAForm.Image4.Canvas.MoveTo(x,y);
  for i:=2 to maxResults do
  begin
    x := round(scale[1,4]*Results[i].e1);
    y := TGAForm.Image4.Height - round(scale[2,4]*Results[i].u);
    TGAForm.Image4.Canvas.LineTo(x,y);
  end;

  TGAForm.Image2.Canvas.Pen.Color := clGreen;
  TGAForm.Image3.Canvas.Pen.Color := clGreen;
  TGAForm.Image4.Canvas.Pen.Color := clGreen;

  //wykres nr 2
  x := round(scale[1,2]*Results[1].pe);
  y := TGAForm.Image2.Height - round(scale[2,2]*Results[1].q);
  TGAForm.Image2.Canvas.MoveTo(x,y);
  for i:=2 to maxResults do
  begin
    x := round(scale[1,2]*Results[i].pe);
    y := TGAForm.Image2.Height - round(scale[2,2]*Results[i].q);
    TGAForm.Image2.Canvas.LineTo(x,y);
  end;

  //wykres nr 3
  x := round(scale[1,3]*Results[1].e1);
  y := TGAForm.Image3.Height - round(scale[2,3]*Results[1].s1eds3e);
  TGAForm.Image3.Canvas.MoveTo(x,y);
  for i:=2 to maxResults do
  begin
    x := round(scale[1,3]*Results[i].e1);
    y := TGAForm.Image3.Height - round(scale[2,3]*Results[i].s1eds3e);
    TGAForm.Image3.Canvas.LineTo(x,y);
  end;

  TGAForm.Update;
end;


function ShrinkName( nazwa : string; dlugosc : word ) : string;
var buf : string;
      i : word;
begin
  if Length(nazwa)>dlugosc then
  begin
    buf := '...';
    for i:=Length(nazwa)-dlugosc to Length(nazwa) do buf := buf + nazwa[i];
  end
  else
    buf := nazwa;
  ShrinkName := buf;
end;

procedure TTGAForm.ButtonOpenTClick(Sender: TObject);

var Tin : TextFile;
      c : char;
      i : word;
    buf : string;

begin
  OpenDialog1.Title := 'Read experimental data';
  OpenDialog1.FilterIndex := 1;
  If OpenDialog1.Execute then
  begin
    CurrentDir := '\';
    buf := '';
    c := #27;
    FullProbName := OpenDialog1.FileName;
    for i:=length(FullProbName) downto 1 do
    begin
      if c=#27 then
      begin
        if FullProbName[i]='\' then
          c:=#0
        else
          buf := buf + FullProbName[i];
      end
      else
        CurrentDir := CurrentDir + FullProbName[i];
    end;
    ProbName:='';
    for i:=length(buf) downto 5 do ProbName := ProbName + buf[i];
    buf := CurrentDir;
    CurrentDir := '';
    for i:=length(buf) downto 1 do CurrentDir := CurrentDir + buf[i];
    LabelDir.Caption := CurrentDir;
    BestFitName := FullProbName + '.best.txt';
    AssignFile(Tin,FullProbName);
    Reset(Tin);
    ReadLn(Tin, c, c, h, c, c, c, r);
    ReadLn(Tin);
    for i:=1 to 4 do
    begin
      max[1,i] := 0.0;
      max[2,i] := 0.0;
    end;
    i:=0;
    repeat
      Inc(i);
      ReadLn(Tin, Data[i].S, Data[i].z, Data[i].u, Data[i].A, Data[i].e1,
                  Data[i].s1, Data[i].s3, Data[i].s1e, Data[i].s3e, Data[i].p,
                  Data[i].q, Data[i].pe, Data[i].s1ds3, Data[i].s1eds3e, Data[i].s1ms3);
      if Data[i].e1 > max[1,1] then max[1,1]:=Data[i].e1;
      if (Data[i].s1ms3) > max[2,1] then max[2,1]:=Data[i].s1ms3;
      if Data[i].p > max[1,2] then max[1,2]:=Data[i].p;
      if Data[i].q > max[2,2] then max[2,2]:=Data[i].q;
      if (Data[i].s1ds3) > max[2,3] then max[2,3]:=Data[i].s1ds3;
      if (Data[i].s1eds3e) > max[2,3] then max[2,3]:=Data[i].s1eds3e;
      if Data[i].u > max[2,4] then max[2,4]:=Data[i].u;
    until eof(Tin);
    CloseFile(Tin);
    maxData := i;
    LabelT1.Caption := 'Number of items: ' + IntToStr(maxData);
    LabelT2.Caption := 'Sample r/h: ' + FloatToStrF(r,fffixed,4,2) + '/' + FloatToStrF(h,fffixed,4,2);
    GroupBox1.Caption := ' Triaxial: '+ ProbName + ' ';
    LabelTriaxFile.Caption := ShrinkName(FullProbName,20);
    ButtonOpenT.Enabled := False;
    scale[1,1] := 0.95 * Image1.Width / max[1,1];
    scale[2,1] := 0.75 * Image1.Height / max[2,1];
    scale[1,2] := 0.95 * Image2.Width / max[1,2];
    scale[2,2] := 0.75 * Image2.Height / max[2,2];
    scale[1,3] := 0.95 * Image3.Width / max[1,1];
    scale[2,3] := 0.75 * Image3.Height / max[2,3];
    scale[1,4] := 0.95 * Image4.Width / max[1,1];
    scale[2,4] := 0.75 * Image4.Height / max[2,4];
    DrawExp;
  end;
end;

procedure TTGAForm.ButtonOpenFClick(Sender: TObject);

var Tin : TextFile;
      c : char;
  i,nod : word;
    dum : double;
    buf : string;

begin
  OpenDialog1.Title := 'Read FEM model parameters';
  OpenDialog1.FilterIndex := 2;
  If OpenDialog1.Execute then
  begin
    buf:='';
    c:=#27;
    FullFEMName := OpenDialog1.FileName;
    FEMOutName := '';
    for i:=1 to length(FullFEMName)-4 do FEMOutName := FEMOutName + FullFEMName[i];
    FEMEndName := FEMOutName + '.matlab.txt';
    FEMCTRName := FEMOutName + '.CTR';
    FEMLoadDisp:= FemOutName + '.LOAD.DISP.TXT';
    FEMOutName := FEMOutName + '.triax.txt';
    for i:=length(FullFEMName) downto 1 do
    begin
      if c=#27 then
      begin
        if FullFEMName[i]='\' then
          c:=#0
        else
          buf := buf + FullFEMName[i];
      end;
    end;
    FEMName:='';
    for i:=length(buf) downto 5 do FEMName := FEMName + buf[i];
    AssignFile(Tin,FullFEMName);
    Reset(Tin);
    for i:=1 to 5 do ReadLn(Tin, FEMPassiveData[i]);
    for i:=0 to 18 do Read(Tin, FEMActiveData[i]);
    ReadLn(Tin);
    for i:=6 to 20 do ReadLn(Tin, FEMPassiveData[i]);
    CloseFile(Tin);
    Reset(Tin);
    for i:=1 to 11 do ReadLn(Tin);
    ReadLn(Tin, dum, dum, dum, i, dum, ITRmax, dum);
    for i:=1 to 4 do ReadLn(Tin);
    ReadLn(Tin, i, nod);
    CloseFile(Tin);
    if i <> 1 then MessageDlg('Node monitor <> 1!', mtError, [mbOK], 0);
    FEMMonName := CurrentDir + 'FEM\' + FEMname + '.' + IntToStr(nod) + '.TXT';
    LabelF1.Caption := 'Ver:' + FEMPassiveData[1]+'/ITR:'+IntToStr(ITRmax);
    LabelF2.Caption := ShrinkName(FEMMonName,20);
    GroupBox2.Caption := ' FEM: '+ FEMName + ' ';
    LabelFEMin.Caption := ShrinkName(FullFEMName,20);
    LabelFEMout.Caption := ShrinkName(FEMOutName,20);
    LabelFEMctr.Caption := ShrinkName(FEMCTRName,20);
    ButtonOpenF.Enabled := False;
  end;
end;


procedure TTGAForm.ButtonOpenGClick(Sender: TObject);

var Tin : TextFile;
      c : char;
      i : word;
    buf : string;
    info : string[10];

begin
  OpenDialog1.Title := 'Read GA parameters';
  OpenDialog1.FilterIndex := 3;
  If OpenDialog1.Execute then
  begin
    buf:='';
    c:=#27;
    FullGAname := OpenDialog1.FileName;
    GAName := '';
    for i:=1 to length(FullGAname)-3 do GAName := GAName + FullGAName[i];
    GACTRName := GAName + '.ERR';
    GAOutName := GAname + '.PHT';
    BestName := GAname + '.BEST.TXT';
    GADatName := GAname + '.DAT';
    GAnameAGA := GAname + '.AGA';
    for i:=length(FullGAname) downto 1 do
    begin
      if c=#27 then
      begin
        if FullGAName[i]='\' then
          c:=#0
        else
          buf := buf + FullGAName[i];
      end;
    end;
    GAName:='';
    for i:=length(buf) downto 4 do GAname := GAname + buf[i];
    AssignFile(Tin,FullGAName);
    Reset(Tin);
    for i:=1 to 4 do ReadLn(Tin);
    ReadLn(Tin, info, NVariabs );
    for i:=1 to (4 * NVariabs + 7)  do ReadLn(Tin);
    ReadLn(Tin, info, GACounterMax );
    CloseFile(Tin);
    LabelG1.Caption := 'ITR:'+IntToStr(GACounterMax)+'/VAR:'+IntToStr(NVariabs);
    LabelG2.Caption := ShrinkName(GAOutName,20);
    GroupBox3.Caption := ' GA: '+ GAName + ' ';
    LabelGAin.Caption := ShrinkName(FullGAname,20);
    LabelGAout.Caption := ShrinkName(GAOutname,20);
    LabelGActr.Caption := ShrinkName(GACTRname,20);
    ButtonOpenG.Enabled := False;
    if NVariabs <> 18 then MessageDlg('Incorrect number of variables!', mtError, [mbOK],0);
  end;
end;


procedure SaveINP;

var Tout : TextFile;
       i : word;
begin
  AssignFile(Tout,FullFEMName );
  Rewrite(Tout);
  for i:=1 to 5 do WriteLn(Tout, FEMPassiveData[i]);
  Write(Tout, FEMActiveData[0]:3:0);
  for i:=1 to 18 do Write(Tout, FEMActiveData[i]:12:3);
  WriteLn(Tout);
  for i:=6 to 20 do WriteLn(Tout, FEMPassiveData[i]);
  CloseFile(Tout);
end;

procedure ReadFEMRes;
var  Tres : TextFile;
      i,j : word;
      a:array[1..5] of double;
begin
  AssignFile(Tres, FEMOutName);
  Reset(Tres);
  ReadLn(Tres);
  i:=0;
  repeat
    Inc(i);
    Results[i].sr := 0.0;
    Results[i].sz := 0.0;
    Results[i].trz := 0.0;
    Results[i].st := 0.0;
    Results[i].u := 0.0;
    Read(Tres,Results[i].dz);
    Results[i].e1 := Results[i].dz / (-1.0 * h / 1000.0) * 100.0;
    for j:=1 to 9 do
    begin
      Read(Tres,a[1],a[2],a[3],a[4],a[5]);
      Results[i].sr := Results[i].sr + a[1];
      Results[i].sz := Results[i].sz + a[2];
      Results[i].trz := Results[i].trz + a[3];
      Results[i].st := Results[i].st + a[4];
      Results[i].u := Results[i].u + a[5];
    end;
    ReadLn(Tres);
    Results[i].sr := Results[i].sr / -9.0;
    Results[i].sz := Results[i].sz / -9.0;
    Results[i].trz := Results[i].trz / -9.0;
    Results[i].st := Results[i].st / -9.0;
    Results[i].u := Results[i].u / -9.0;
    Results[i].s1ms3 := Results[i].sz - Results[i].sr;
    Results[i].s1ds3 := Results[i].sz / Results[i].sr;
    Results[i].s1eds3e := (Results[i].sz - Results[i].u) / (Results[i].sr - Results[i].u);
    Results[i].p := 0.5 * (Results[i].sz + Results[i].sr);
    Results[i].pe := 0.5 * (Results[i].sz + Results[i].sr - 2 * Results[i].u);
    Results[i].q := 0.5 * (Results[i].sz - Results[i].sr);
  until eof(Tres);
  CloseFile(Tres);
  Erase(Tres);
  maxResults := i;
  AssignFile(Tres, FEMCtrName);
  Reset(Tres);
  ReadLn(Tres);
  ReadLn(Tres,ITR);
  CloseFile(Tres);
  Erase(Tres);
  AssignFile(Tres, FEMMonName);
  Erase(Tres);
  AssignFile(Tres, FEMLoadDisp);
  Erase(Tres);
end;


procedure TTGAForm.WaitFEMDone(Sender: TObject);
var dat : TextFile;
     ok : boolean;
     i,j,maxk:word;
     DataInt : array[1..300] of Experiment;
     ResultsInt : array[1..300] of Calculation;
begin
  Inc(WaitCounter);
  if WaitCounter = 50 then begin FormWarning.Visible:=True; FormWarning.Update; end;
  if FEMok = 0 then begin if FileExists(FEMEndName) then FEMok := 1; end;
  if FEMok = 1 then begin if FileExists(FEMOutName) then FEMok := 2; end;
  if FEMok = 2 then begin if FileExists(FEMCtrName) then FEMok := 3; end;
  if FEMok = 3 then begin if FileExists(FEMMonName) then FEMok := 4; end;
  if FEMok = 4 then begin if FileExists(FEMLoadDisp) then FEMok := 5; end;
  if FEMok = 5 then
  begin
    FormWarning.Visible := False;
    FormWarning.Update;
    Timer1.Enabled:=False;
    sleep(SleepVal);
    LabelFEM.Color := clBlack;
    Update;
    AssignFile(dat,FEMEndName);
    Erase(dat);
    ReadFEMRes;
    DrawExp;
    DrawFEM;
    Objective := 0.0;
    if ((ITR < ITRmax) and (MaxResults > 0)) then
    begin
      maxk:=0;
      for i:=1 to maxResults do
      begin
        j:=0;
        ok := false;
        repeat
          inc(j);
          if j>maxData then ok := true;
          if (Data[j].e1 >= Results[i].e1) and (ok = false) then
          begin
            inc(maxk);
            ok := true;
            Objective := Objective + sqr(Results[i].s1ms3 - Data[j].s1ms3);
            if RadioButtonTotal.Checked = True then
            begin
              Objective := Objective + sqr(Results[i].s1ds3 - Data[j].s1ds3);
            end
            else
            begin
              Objective := Objective + sqr(Results[i].u - Data[j].u);
              Objective := Objective + sqr(Results[i].s1eds3e - Data[j].s1eds3e);
            end;
            DataInt[maxk] := Data[j];
            ResultsInt[maxk] := Results[i];
          end;
        until ok = true;
      end;
      if RadioButtonTotal.Checked = True then
        Objective := sqrt(Objective) / (maxResults * 2)
      else
        Objective := sqrt(Objective) / (maxResults * 3);
      if Objective > 0.0 then
        Objective := 1.0 / Objective
      else
        Objective := 1.0;
      LabelObj.Caption := FloatToStrF(Objective, fffixed, 8, 3);
      Update;
    end;
    if Timer1.Tag = 0 then
    begin
      AssignFile(dat,GADatName);
      Append(dat);
      WriteLn(dat,Objective);
      CloseFile(dat);
      Timer1.Interval := IntVal;
      Timer1.OnTimer := ButtonStartClick;
      Timer1.Enabled := True;
    end
    else
    begin
      Timer1.Tag := 0;
      AssignFile(dat,BestFitName);
      Rewrite(dat);
      WriteLn(dat,'e1':12,' ','Exp:s1-s3':12,' ','FEM:s1-s3':12,' ','Exp:s1/s3':12,
                          ' ','FEM:s1/s3':12,' ','Exp:u':12,' ','FEM:u':12,' ',
                          'Exp:s1e/s3e':12,' ','FEM:s1e/s3e':12);
      for i:=1 to maxk do WriteLn(dat,DataInt[i].e1:12,' ',DataInt[i].s1ms3:12,' ',
         ResultsInt[i].s1ms3:12,' ',DataInt[i].s1ds3:12,' ',ResultsInt[i].s1ds3:12,' ',
         DataInt[i].u:12,' ',ResultsInt[i].u:12,' ',DataInt[i].s1eds3e:12,' ',ResultsInt[i].s1eds3e:12);
      CloseFile(dat);
    end;
  end;
end;

procedure TTGAForm.WaitGADone(Sender: TObject);
var t : TextFile;
    info : string;
    inf10 : string[10];
    i,j : word;
begin
  if ( FileExists(GACTRName) and FileExists(GAOutName) ) then
  begin
    Timer1.Enabled := False;
    sleep(SleepVal);
    LabelGA.Color := clBlack;
    Update;
    AssignFile(t,GACtrName);
    Reset(t);
    Readln(t,info);
    CloseFile(t);
    if info = 'Program: OK' then
    begin
      AssignFile(t,GAOutName);
      Reset(t);
      Readln(t,inf10,FEMCounterMax);
      for i:=1 to FEMCounterMax do
      begin
        for j:=1 to NVariabs do Read(t,PHT[j,i]);
        ReadLn(t);
      end;
      CloseFile(t);
      AssignFile(t,GADatName);
      ReWrite(t);
      CloseFile(t);
      Timer1.OnTimer := ButtonStartClick;
      Timer1.Interval := IntVal;
      Timer1.Enabled := True;
    end
    else
    begin
      LabelGA.Color := clRed;
      Update;
      Timer1.Enabled := True;
    end;
  end;
end;

procedure TTGAForm.ButtonStartClick(Sender: TObject);
var dat:textfile;
    i : byte;
    FullProgPath: PChar;
begin
  Timer1.Enabled := False;
  If TrackBar1.Enabled = True then TrackBar1.Enabled := False;
  If TrackBar2.Enabled = True then TrackBar2.Enabled := False;
  FEMok := 0;
  WaitCounter := 0;
  if GACounter>0 then
  begin
    Inc(FEMCounter);
    if FEMCounter > FEMCounterMax then
    begin
      FEMCounter := 0;
    end
    else
    begin
      for i:=1 to 18 do FEMActiveData[i] := PHT[i,FEMCounter];
      SaveINP;
      LabelFEM.Color := clRed;
      ButtonStart.Caption := IntToStr(GACounter)+'/'+IntToStr(FEMCounter);
      Update;
      FullProgPath := PChar(CurrentDir + 'FEM\FemTriaxTest.exe ' + CurrentDir + 'FEM\' + FEMname + ' K0');
      WinExec(FullProgPath, SW_HIDE);
      Timer1.Interval := IntVal;
      Timer1.Tag := 0;
      Timer1.OnTimer := WaitFEMDone;
      Timer1.Enabled := True;
    end;
  end;
  if FEMCounter = 0 then
  begin
    if GACounter = 0 then
    begin
      DateTime1 := Time;
      Caption := constCaption + ' ' +TimeToStr(DateTime1);
      Update;
      FullProgPath := PChar(CurrentDir + 'GA\AGA.exe ' + CurrentDir + 'GA\' + GAname + ' first');
    end
    else
      FullProgPath := PChar(CurrentDir + 'GA\AGA.exe ' + CurrentDir + 'GA\' + GAname + ' next');
    Inc(GACounter);
    if GACounter > GACounterMax then
    begin
      DateTime2 := Time;
      MessageDlg('Done! ('+TimeToStr(DateTime2)+')',mtInformation,[mbOK],0);
    end
    else
    begin
      ButtonStart.Caption := IntToStr(GACounter)+'/'+IntToStr(FEMCounter);
      LabelGA.Color := clRed;
      Update;
      WinExec(FullProgPath, SW_HIDE);
      Timer1.Interval := IntVal;
      Timer1.OnTimer := WaitGADone;
      Timer1.Enabled := True;
    end;
  end;
end;

procedure TTGAForm.ButtonBestClick(Sender: TObject);
var t:TextFile;
    iter, i : byte;
    FullProgPath: PChar;
    Obj : double;
begin
  AssignFile(t, BestName);
  Reset(t);
  repeat
    Readln(t);
    Read(t,iter, Obj);
    for i:=1 to 18 do Read(t,FEMActiveData[i]);
    ReadLn(t);
  until eof(t);
  CloseFile(t);
  SaveInp;
  LabelFEM.Color := clRed;
  Update;
  FullProgPath := PChar(CurrentDir + 'FEM\FemTriaxTest.exe ' + CurrentDir + 'FEM\' + FEMname + ' K0');
  WinExec(FullProgPath, SW_HIDE);
  Timer1.Interval := IntVal;
  Timer1.Tag := 1;
  Timer1.OnTimer := WaitFEMDone;
  Timer1.Enabled := True;
end;

procedure TTGAForm.ButtonContinueClick(Sender: TObject);
var dat:textfile;
    i : byte;
    FullProgPath: PChar;
    inf : string[6];
begin
  If TrackBar1.Enabled = True then TrackBar1.Enabled := False;
  If TrackBar2.Enabled = True then TrackBar2.Enabled := False;
  DateTime1 := Time;
  Caption := constCaption + ' ' +TimeToStr(DateTime1);
  Update;
  AssignFile(dat,GAnameAGA);
  Reset(dat);
  ReadLn(dat,inf,GACounter);
  CloseFile(dat);
  FEMCounter := 0;
  FEMok := 0;
  WaitCounter := 0;
  ButtonStart.Caption := IntToStr(GACounter)+'/'+IntToStr(FEMCounter);
  Update;
  WinExec(FullProgPath, SW_HIDE);
  Timer1.Interval := IntVal;
  Timer1.OnTimer := WaitGADone;
  Timer1.Enabled := True;
end;

procedure TTGAForm.TrackBarOnChange(Sender: TObject);
begin
  IntVal := TrackBar1.Position * 50;
  SleepVal := TrackBar2.Position * 200;
  Panel1.Caption := 'Intervals:' + IntToStr(IntVal) + '/' + IntToStr(SleepVal) + '[ms]';
  Update;
end;


end.
