/*
	File			:	TQAX.CPP
	Identification	:	T&Q elements procedures
	Author			:	P.E.Srokosz, 2006
	Purpose			:	Finite Elelements Method in Geomechanics
	Created			:	15.06.2006
	Last modified	:	15.07.2006
	Content			:	createKm, calcEpsSig, ufTQ, BodyLoads, Report
*/

#ifndef _srokosz_TQAX_cpp
#define _srokosz_TQAX_cpp

#include "FEMLibAX.h"
#include "MCPLAX.H"
#define _USE_MATH_DEFINES
#include <math.h>
//elements
#include "T3AX.H"
#include "T6AX.H"
#include "Q4AX.H"
#include "Q8AX.H"
#include "Q9AX.H"

/* BEGIN */

//-------------------------------------------------------------------------------------
//stiffness matrix Km
void createKm( void )
{
	long iElem;
	
	KmZERO( );

	for(iElem=0; iElem<NELEM; iElem++)
	{
		if( ELEM[iElem].typ == 3 ) KmT3( iElem );
	    if( ELEM[iElem].typ == 4 ) KmQ4( iElem );
		if( ELEM[iElem].typ == 6 ) KmT6( iElem );
	    if( ELEM[iElem].typ == 8 ) KmQ8( iElem );
	    if( ELEM[iElem].typ == 9 ) KmQ9( iElem );
	}
}//createKm
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//eps & sig increments vectors
void calcEpsSig( int opt )
{
	long iElem;

	for(iElem=0; iElem<NELEM; iElem++) 
	{
		if( ELEM[iElem].typ == 3 ) esT3( iElem, opt );
		if( ELEM[iElem].typ == 4 ) esQ4( iElem, opt );
		if( ELEM[iElem].typ == 6 ) esT6( iElem, opt );
		if( ELEM[iElem].typ == 8 ) esQ8( iElem, opt );
		if( ELEM[iElem].typ == 9 ) esQ9( iElem, opt );
	}
}//calcEpsSig
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//depsvp & dsigvp increments vectors
void calcEpsSigVP( void )
{
	long iElem;

	for(iElem=0; iElem<NELEM; iElem++) 
	{
		if( ELEM[iElem].typ == 3 ) vpT3( iElem );
		if( ELEM[iElem].typ == 4 ) vpQ4( iElem );
		if( ELEM[iElem].typ == 6 ) vpT6( iElem );
		if( ELEM[iElem].typ == 8 ) vpQ8( iElem );
		if( ELEM[iElem].typ == 9 ) vpQ9( iElem );
	}
}//calcEpsSig
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//recalculates forces and prescribed u-values
void KmufTQ( void )
{
	long i, row, col;

	//creates stifness matrix
	KmZERO( );
	for( i=0; i<NELEM; i++ )	
	{
		if( ELEM[i].typ == 3 ) KmT3( i );
		if( ELEM[i].typ == 4 ) KmQ4( i );
		if( ELEM[i].typ == 6 ) KmT6( i );
		if( ELEM[i].typ == 8 ) KmQ8( i );
		if( ELEM[i].typ == 9 ) KmQ9( i );
	}

	//updates u-vector (prescribed displacements)
	if( NBND>0 )
	{
		for( i=1; i<=NBND; i++ ) 
		{
			row = 2 * Bnd[i].node;
			if( fabs(Bnd[i].ux)<One ) u[row] = Bnd[i].ux;
			row++;
			if( fabs(Bnd[i].uy)<One ) u[row] = Bnd[i].uy;
		}
	}
		
	//all nodal forces: f=Km*u
	for( row=0; row<NDIM; row++ )
	{
		f[row] = Zero;
		for(col=0; col<NDIM; col++)	f[row] += Km[row][col] * u[col];
	}

}//KmufTQ
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//reallocates forces and prescribed u-values
void upfTQ( void )
{
	long i, row;
	double f_upload[MaxDim];

	//updates f_calc-vector

	//preparing upload
	for( i=0L; i<NDIM; i++ ) f_upload[i] = fResidual[i];

	//removing constrained values
	if( NBND>0L )
	{
		for( i=1L; i<=NBND; i++ ) 
		{
			row = 2L * Bnd[i].node;
			if( fabs(Bnd[i].ux) < Free ) f_upload[row] = Zero;
			row++;
			if( fabs(Bnd[i].uy) < Free ) f_upload[row] = Zero;
		}
	}

	//updating calculation vector
	for( i=0L; i<NDIM; i++ ) f[i] += f_upload[i];

}//upfTQ
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//reallocates forces and prescribed u-values, cln=1 :  cleans reactions
void ufTQ( double buffer[MaxDim], int cln )
{
	long i, row;

	//updates u&f-vector (prescribed displacements & reactions)

	//rebuild load vector
	for( i=0L; i<NDIM; i++ ) f[i] = buffer[i];

	if( NBND>0L )
	{
		for( i=1L; i<=NBND; i++ ) 
		{
			row = 2L * Bnd[i].node;
			if( fabs(Bnd[i].ux) < Free ) 
			{
				f[row] = Zero;
				if( cln==0 ) f[row] = u[row]; 
				u[row] = Bnd[i].ux;
			}
			row++;
			if( fabs(Bnd[i].uy) < Free ) 
			{
				f[row] = Zero;
				if( cln==0 ) f[row] = u[row]; 
				u[row] = Bnd[i].uy;
			}
		}
	}
		
}//ufTQ
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//body loads, as residual loads
double ResidualLoads( int opt )
{
	long iElem;
	double Srl;

	fRZERO( );
	
	for(iElem=0; iElem<NELEM; iElem++) 
	{
		if( ELEM[iElem].typ == 3 ) rlT3( iElem, opt );
		if( ELEM[iElem].typ == 4 ) rlQ4( iElem, opt );
		if( ELEM[iElem].typ == 6 ) rlT6( iElem, opt );
		if( ELEM[iElem].typ == 8 ) rlQ8( iElem, opt );
		if( ELEM[iElem].typ == 9 ) rlQ9( iElem, opt );
	}

	Srl = normV( fResidual, NDIM );

	return Srl;
}//ResidualLoads
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//report : plastic & violation points
COOR2L Report( void )
{
	long iElem, iGauss, maxGauss;
	COOR2L pvF;
	
	pvF.x = 0L;
	pvF.y = 0L;

	for(iElem=0L; iElem<NELEM; iElem++) 
	{
		if( ELEM[iElem].typ == 3 ) maxGauss = 1;
		if( ELEM[iElem].typ == 4 ) maxGauss = 4;
		if( ELEM[iElem].typ == 6 ) maxGauss = 3;
		if( ELEM[iElem].typ == 8 ) maxGauss = 9;
		if( ELEM[iElem].typ == 9 ) maxGauss = 9;

		for( iGauss=0L; iGauss<maxGauss; iGauss++ )
		{
			if( ELEM[iElem].plas[iGauss] > 0L ) pvF.x += 1L;
			if( ELEM[iElem].Fmc[iGauss] > Fmin ) pvF.y += 1L;
		}
	}

	return pvF;
}//Report
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//Zeroing incrementals
void ZeroELEMincr( void )
{
	long iElem, iGauss;

	for( iElem=0L; iElem<NELEM; iElem++ ) 
	{
		for( iGauss=0L; iGauss<9L; iGauss++ )
		{
			ELEM[iElem].dsig[iGauss]  = COOR3_ZERO;
			ELEM[iElem].deps[iGauss]  = COOR3_ZERO;
			ELEM[iElem].dsigvp[iGauss] = COOR3_ZERO;
			ELEM[iElem].depsvp[iGauss] = COOR3_ZERO;
		}
	}

}//ZeroELEMincr
//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
//updating total stress and strain in elements, zeroing incrementals
void upEpsSig( void )
{
	long iElem, iGauss, maxGauss;

	for( iElem=0L; iElem<NELEM; iElem++ ) 
	{
		if( ELEM[iElem].typ == 3 ) maxGauss = 1;
		if( ELEM[iElem].typ == 4 ) maxGauss = 4;
		if( ELEM[iElem].typ == 6 ) maxGauss = 3;
		if( ELEM[iElem].typ == 8 ) maxGauss = 9;
		if( ELEM[iElem].typ == 9 ) maxGauss = 9;
		
		for( iGauss=0L; iGauss<maxGauss; iGauss++ )
		{
			ELEM[iElem].sig[iGauss].x  += ELEM[iElem].dsig[iGauss].x;
			ELEM[iElem].sig[iGauss].y  += ELEM[iElem].dsig[iGauss].y;
			ELEM[iElem].sig[iGauss].xy += ELEM[iElem].dsig[iGauss].xy;
			ELEM[iElem].sig[iGauss].z  += ELEM[iElem].dsig[iGauss].z;
			ELEM[iElem].eps[iGauss].x  += ELEM[iElem].deps[iGauss].x;
			ELEM[iElem].eps[iGauss].y  += ELEM[iElem].deps[iGauss].y;
			ELEM[iElem].eps[iGauss].xy += ELEM[iElem].deps[iGauss].xy;
			ELEM[iElem].eps[iGauss].z  += ELEM[iElem].deps[iGauss].z;
		}
		for( iGauss=0L; iGauss<9L; iGauss++ )
		{
			ELEM[iElem].dsig[iGauss] = COOR3_ZERO;
			ELEM[iElem].deps[iGauss] = COOR3_ZERO;
		}
	}

}//upEpsSig
//-------------------------------------------------------------------------------------


/* END */

#endif
