/*
	File			:	MMC.CPP
	Identification	:	Library of functions and procedures for FEM
						Mohr-Coulomb plasticity with hardening/softening
	Author			:	P.E.Srokosz, 2006
	Purpose			:	Finite Elelements Method in Geomechanics
	Created			:	25.08.2006
	Last modified	:	25.08.2006
	Content			:	

*/
#ifndef _srokosz_MMC_h
#define _srokosz_MMC_h

extern double dpds[4], dJds[4], dtds[4];

double Fi_MMC( double, MATPAR );
double c_MMC( double, MATPAR );
double Psi_MMC( double, MATPAR );
double Fmc_MMC( double [], double, double );
void DEP_MMC( double [], double , MATPAR );
double calcLAMBDA( double [] );
double invarT_MMC( double [] );
void derivInvar_MMC( double [] );
void derivFQmc_MMC( double [], double, double, double );
void derivFQdp_MMC( double, double, double );

#endif