/*
	File			:	MCPLAX.H
	Identification	:	Library of functions and procedures for FEM
						Mohr-Coulomb plasticity
	Author			:	P.E.Srokosz, 2006
	Purpose			:	Finite Elelements Method in Geomechanics
	Created			:	12.07.2006
	Last modified	:	12.07.2006
*/

#ifndef _srokosz_MCPLAX_h
#define _srokosz_MCPLAX_h

//variables
extern double DP[4][4], DEP[4][4], NRctrl;
extern double DFDEDQ, DF[4], DQ[4], DEDQ[4], DFDE[4], A;
//control variables read from INP file
extern double Fmin;		//F equal "0.0"
extern double SStol;	//max error of substepping
extern long SSmax;		//max substepping iterations
extern double NRtol;	//Newton-Raphson tolerance error
extern long NRmax;		//max Newton-Raphson iterations
extern double INCmax;	//flag of auto change load increments
extern long INCauto;	//flag of auto change increment size
extern long DEPuse;		//flag : use DEP or DE
extern long VPuse;		//flag : use Visco-plastic (1) or Newton-Raphson (0)
extern double Collapse; //max error indicating collaps

//functions
void mkDEP( long, double [], double, MATPAR );
double findAlfa( double [], double [], double, double );
double substepsRK( double [], double [], double, MATPAR );
double calcDSIG( COOR3, COOR3, COOR3, double, MATPAR );
double calcVP( COOR3, COOR3, COOR3, double, MATPAR );

#endif