#ifndef _srokosz_FEMVars_h

#define _srokosz_FEMVars_h
#define _USE_MATH_DEFINES
#include <math.h>
#define Free		(double) 20.0		//for prescribed displacement 
#define EPS			(double) 1.0E-15	//for GAUSS elimination & KmINVERSE: EPS means "0.0"
#define nonZERO		(double) 1.0E-36	//value close to zero, but nonzero
#define NGold		(double) -0.618		//Gold section
#define KeBULK		(double) 1.0E+4		//bulk modulus of water
#define g			(double) -9.81		//gravity acceleration
#define INClimit	(double) 1.0		//limit of NR increments
#define NOne		(double) -1.0
#define NHalf		(double) -0.5
#define Zero		(double) 0.0
#define Quarter		(double) 0.25
#define Half		(double) 0.5
#define One			(double) 1.0
#define Two			(double) 2.0
#define Three		(double) 3.0
#define Four		(double) 4.0
#define Five		(double) 5.0
#define Six			(double) 6.0
#define NSqrtI3		(double) NOne * sqrt( One / Three )
#define SqrtI3		(double) sqrt( One / Three )
#define NSqrtI5		(double) NOne * sqrt( Three / Five )
#define SqrtI5		(double) sqrt( Three / Five )
#define WT6			(double) One / Six
#define WG4			(double) 25.0/81.0
#define WG2 		(double) 40.0/81.0
#define WG1 		(double) 64.0/81.0
#define MaxBound	(long) 500
#define MaxDim		(long) 5400
#define MaxElem		(long) 700
#define MaxNode		(long) 2700
#define BMPsize		(long) 20000000

struct COOR4
{
	double one, two, three, four, five, six, seven, eight, nine;
};

struct COOR3
{
	double x, y, xy, z;
};

struct COOR2 
{
	double x, y;
};

struct MATPAR
{
	double ro, E, ni, Ke, Edp_cp1, Edp_cp2, Edp_cr, Edp_Fip1, Edp_Fip2, Edp_Fir, ci, cp, cr, Fii, Fip, Fir, beta, Psir;
};

struct PARAMS
{
	int typ;      //3-T3, 4-Q4, 6-T6, 8-Q8, 9-Q9 
	long node[9], plas[9];
	MATPAR matpars;
	double Ke, u[9], Fmc[9], Edp[9];
	COOR3 eps[9], sig[9], dsig[9], deps[9], depsvp[9], dsigvp[9], dQ[9];
	COOR2 Gauss[9];
};

struct BOUNDS
{
	long node;
	double ux, uy;
};

struct GAUSSPOINTS
{
	double ksi, eta, w;
};

struct COOR2L 
{
	long x, y;
};

#endif