/*
	File			:	mcdpl.cpp
	Identification	:	Library of functions and procedures for FEM
						DP, DQ, DF by Griffiths&Smiths
	Author			:	Griffiths&Smiths by P.E.Srokosz, 2006
	Purpose			:	Finite Elelements Method in Geomechanics
	Created			:	21.08.2006
	Last modified	:	21.08.2006
	Content			:	mcdp
*/

#ifndef _srokosz_mcdpl_cpp
#define _srokosz_mcdpl_cpp

#include <iso646.h>
#define _USE_MATH_DEFINES
#include <math.h>
#include <stdio.h>
#include "FEMLib.h"
#include "MCPL.h"
#include "FEMVars.h"

/* BEGIN */

void GriffithsDEP( double stress[4], double phi, double psi )
/*
 This subroutine forms the plastic stress/strain matrix
 for a Mohr-Coulomb material (phi,psi in degrees).
								Griffiths&Smiths
*/
{
	double t1, t2, t3, t4, t6, t8, t10, t12, t13, t14, t16, t17, t18, t19, t20;
	double t21, t22, t23, t24, t25, t26, t28, t30, t31, t33, t34, t35, t36;
	double t38, t41, t43, t44, t46, t49, t53, t54, t55;
	double t60, t61, t64, t68, t70, t71, t73, t74, t77, t83, t84, t85;
	double t89, t94, t97, t101, t111, t129;
	double t140, t152, pm, pi, phir, snph, snth, sq3, sx, sy, sz;
	double txy, snps, psir, denom;
	long i, j;
 
	pi = acos( NOne ); 
	phir = phi * pi / (double) 180.0;
	snph = sin( phir );
	psir = psi * pi / (double) 180.0;
	snps = sin( psir );
	sq3 = sqrt( Three );
	sx = stress[0];
	sy = stress[1];
	txy = stress[2]; 
	sz = stress[3];   
	t3 = One / Three;
	t4 = ( sx + sy + sz ) * t3;
    t8 = sz - t4;
    t10 = txy * txy;
    t16 = ( sx - sy ) * ( sx - sy );
    t18 = ( sy - sz ) * ( sy - sz );
    t20 = ( sz - sx ) * ( sz - sx );
    t25 = sqrt(( t16 + t18 + t20 ) / Six + t10);
    t26 = t25 * t25;
    t30 = Three * sq3 * (( sx - t4 ) * ( sy - t4 ) * t8 - t8 * t10 ) / Two / t26 / t25;
    if( t30 > One ) t30 = One;
    if( t30 < NOne ) t30 = NOne;
    t31 = asin( t30 );
    t33 = sin( t31 * t3 );
    snth = NOne * t33;
    if( fabs(snth) > (double) 0.49 )
	{
		pm = NOne;
		if( snth < Zero ) pm = One;
		t2 = snph / Three;
		t4 = ( sx - sy ) * ( sx - sy );
		t6 = ( sy - sz ) * ( sy - sz );
		t8 = ( sz - sx ) * ( sz - sx );
		t10 = One / Six;
		t12 = txy * txy;
		t14 = sqrt(( t4 + t6 + t8 ) * t10 + t12 );
        t17 = One / t14 / sq3;
		t18 = Half;
        t19 = t17 * t18;
        t21 = Three + pm * snph;
        t23 = Two * sy;
        t24 = Two * sz;
        t31 = Two * sx;
        DF[0] = t2 + t19 * t21 * ( Four * sx - t23 - t24 ) * t10 / Two;
        DF[1] = t2 + t19 * t21 * ( NOne * t31 + Four * sy - t24 ) * t10 / Two;
        DF[2] = t17 * t18 * t21 * txy;
        DF[3] = t2 + t19 * t21 * ( NOne * t23 + Four * sz - t31 ) * t10 / Two;
        t2 = snps / Three;
        t21 = Three + pm * snps;
		DQ[0] = t2 + t19 * t21 * ( Four * sx - t23 - t24 ) * t10 / Two;
		DQ[1] = t2 + t19 * t21 * ( NOne * t31 + Four * sy - t24 ) * t10 / Two;
		DQ[2] = t17 * t18 * t21 * txy;
		DQ[3] = t2 + t19 * t21 * ( NOne * t23 + Four * sz - t31 ) * t10 / Two;
	}
	else
	{
		t1 = One / Three;
        t2 = snph * t1;
        t4 = ( sx - sy ) * ( sx - sy );
		t6 = ( sy - sz ) * ( sy - sz );
		t8 = ( sz - sx ) * ( sz - sx );
		t10 = One / Six;
        t12 = txy * txy;
        t13 = ( t4 + t6 + t8 ) * t10 + t12;
        t14 = sqrt( t13 );
        t16 = Three * sq3;
        t18 = ( sx + sy + sz ) * t1;
        t19 = sx - t18;
        t20 = sy - t18;
        t21 = t19 * t20;
        t22 = sz - t18;
        t25 = t21 * t22 - t22 * t12;
        t26 = Half;
        t28 = t14 * t14;
        t30 = One / t28 / t14;
        t31 = t16 * t25 * t26 * t30;
        if( t31 > One ) t31 = One;
        if( t31 < NOne ) t31 = NOne;
        t33 = asin( t31 );
        t34 = t33 * t1;
        t35 = cos( t34 );
        t36 = sin( t34 );
        t38 = One / sq3;
        t41 = One / t14 * ( t35 + t36 * snph * t38 );
        t43 = Two * sy;
        t44 = Two * sz;
        t46 = ( Four * sx - t43 - t44 ) * t10;
        t49 = One - t1;
        t53 = t19 * t1 * t22;
        t54 = t21 * t1;
        t55 = t1 * t12;
        t60 = t16 * t25;
        t61 = t28 * t28;
        t64 = t26 / t61 / t14;
        t68 = t16 * ( t49 * t20 * t22 - t53 - t54 + t55 ) * t26 * t30 - Three / Two * t60 * t64 * t46;
        t70 = Three * Three;
        t71 = sq3 * sq3;
        t73 = t25 * t25;
        t74 = Four;
        t77 = t13 * t13;
        t83 = sqrt( One - t70 * t71 * t73 / t74 / t77 / t13 );
        t84 = One / t83;
        t85 = t84 * t1;
        t89 = t2 * t38;
        t94 = Two * sx;
        t97 = ( NOne * t94 + Four * sy - t44 ) * t10;
        t101 = t1 * t20 * t22;
        t111 = t16 * ( NOne * t101 + t19 * t49 * t22 - t54 + t55 ) * t26 * t30 - Three / Two * t60 * t64 * t97;
        t129 = NOne * Two * t16 * t22 * txy * t26 * t30 - Three * t60 * t64 * txy;
        t140 = ( NOne * t43 + Four * sz - t94 ) * t10;
        t152 = t16 * ( NOne * t101 - t53 + t21 * t49 - t49 * t12 ) * t26 * t30 - Three / Two * t60 * t64 * t140;
        DF[0] = t2 + t41 * t46 / Two + t14 * ( NOne * t36 * t68 * t85 + t35 * t68 * t84 * t89 );
        DF[1] = t2 + t41 * t97 / Two + t14 * ( NOne * t36 * t111 * t85 + t35 * t111 * t84 * t89 );
        DF[2] = t41 * txy + t14 * ( NOne * t36 * t129 * t85 + t35 * t129 * t84 * t89 );
        DF[3] = t2 + t41 * t140 / Two + t14 * ( NOne * t36 * t152 * t85 + t35 * t152 * t84 * t89 );
        t2 = snps * t1;
        t41 = One / t14 * ( t35 + t36 * snps * t38 );
        t89 = t2 * t38;
        DQ[0] = t2 + t41 * t46 / Two + t14 * ( NOne * t36 * t68 * t85 + t35 * t68 * t84 * t89 );
        DQ[1] = t2 + t41 * t97 / Two + t14 * ( NOne * t36 * t111 * t85 + t35 * t111 * t84 * t89 );
        DQ[2] = t41 * txy + t14 * ( NOne * t36 * t129 * t85 + t35 * t129 * t84 * t89 );
        DQ[3] = t2 + t41 * t140 / Two + t14 * ( NOne * t36 * t152 * t85 + t35 * t152 * t84 * t89 );
	}

	for( i=0L; i<4L; i++ )
	{
		DEDQ[i] = Zero;
		for( j=0L; j<4L; j++ )
		{
			DEDQ[i] += DE[i][j] * DQ[j];
		}
	}

	for( i=0L; i<4L; i++ )
	{
		DFDE[i] = Zero;
		for( j=0L; j<4L; j++ )
		{
			DFDE[i] += DF[j] * DE[j][i];
		}
	}

	denom = Zero;
	for( i=0L; i<4L; i++ ) denom += DFDE[i] * DQ[i];
	DFDEDQ = denom;

	for( i=0L; i<4L; i++ )
	{
		for( j=0L; j<4L; j++ )
		{
			DP[i][j] = DEDQ[i] * DFDE[j] / denom;
		}
	}
}//GriffithsDEP

#endif

/*  END  */