/*
	File			:	FEMLib.h
	Identification	:	Library of functions and procedures for FEM
						interface for FEMLib.cpp
	Author			:	Smith&Griffiths by P.E.Srokosz, 2006
	Purpose			:	Finite Elelements Method in Geomechanics
	Created			:	24.08.2006
	Last modified	:	24.08.2006
*/

#ifndef _srokosz_FEMLib_h

#include "FEMVars.h"

#define _srokosz_FEMLib_h

//variables
extern PARAMS ELEM[MaxElem];
extern COOR2 NODE[MaxNode];
extern BOUNDS Bnd[MaxBound];
extern long NELEM, NNODE, NDIM, NBND, BMPheight, BMPwidth, totalGP, FastDT, IterCtrl, RetCtrl;
extern double Km[MaxDim][MaxDim], DE[4][4], DU[4][4], STRESS[4], STRAIN[4], f[MaxDim], u[MaxDim];
extern double u_act[MaxDim], fResidual[MaxDim], delta, Fsafety, Vcrit, u_incr[MaxDim];
extern double DT, u_elas[MaxDim], NRRelax, f_ext[MaxDim], f_total[MaxDim], fR_copy[MaxDim];
extern GAUSSPOINTS GPQ4[4];
extern GAUSSPOINTS GPT6[3];
extern GAUSSPOINTS GPQ8[9];
extern double INCREMENT, dSTRESS[4];
extern unsigned char BMPData[BMPsize];
extern MATPAR PAR[256], MATPAR_ZERO;
extern long Nmonitor, Iter; //total number of nodes to monitor
extern long NODEmonitor[MaxBound]; //nodes to monitor
extern COOR3 COOR3_ZERO;
extern COOR2 COOR2_ZERO;
extern long MatIdentType; //material identification type in element: 1 averaging of nodes, 2 on center point

//functions
double deg2rad( double );
double rad2deg( double );
void KmZERO( void );
void fZERO( void );
void fRZERO( void );
void uZERO( void );
void BndRESET( void );
void INITALL( void );
double normV( double [], long );
double maxV( double [], long );
void mkNODE( long, double, double );
void loadNODE( long, double, double );
void uploadNODE( long, double, double );
void unloadNODE( long, double, double );
void addR2f( void );
void updatefR( long, double, double );
void mkDE( double, double, double );
void mkDU( double );
void saveCONSTRAINT( long, double, double );
void dispNODE( long, double, double );
void Constraints( void );
void penaltyNODE( long, double, double );
struct COOR2 readNODE( double[], long );
double trunc( double );
int GAUSS( void );
int KmINVERSE( void );

#endif